VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsOptions"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
'-----------------------------------------------------
' MirageBot Options Class
' Written by Christopher Nevin (lancergli@gmail.com)
'-----------------------------------------------------

Option Explicit
Private Const SE As String = "Settings"

Private mNudge As Boolean, mTicTacToe As Boolean, mColors As Boolean, _
    mIdleDim As Boolean, mFriendFilter As Boolean, _
    mHyperlinks As Boolean, mVoidView As Boolean, mHideEditor As Boolean, _
    mTrayMin As Boolean, mSpeak As Boolean, mTrueName As Boolean, mClanRankIcons As Boolean, _
    mPassword As String, mProof As Boolean, mAbbreviate As Boolean, _
    mLogging As Boolean, mAutoReconnect As Boolean, mPlainText As Boolean, mIcons As Integer, _
    mCommandDebug As Boolean, mSmileys As Boolean, mSmileySet As String, mVerbose As Boolean, _
    mAutoConnectAll As Boolean, mAutoHideAll As Boolean, mAutoLockAll As Boolean, mAutoLoadAll As Boolean, _
    mBNLS() As String, mKickFilter As Boolean, mBanFilter As Boolean, mEmoteFilter As Boolean, mAutoFilter As Boolean, mFilterLevel As Integer, mFilterLoad As Boolean, _
    mAccountFilter As Boolean, mJoinFilter As Boolean, mChannel(6) As String, mChannelName(6) As String, _
    mAlertFlood As Boolean, mAlertNoFlood As Boolean, mAlertKicked As Boolean, mPresentFilter As Boolean, mClanRankColors As Boolean
Public ProfileAge As String, ProfileSex As String, ProfileLocation As String, ProfileDescription As String

Public Property Get AlertFlood() As Boolean
    AlertFlood = mAlertFlood
End Property

Public Property Let AlertFlood(ByVal v As Boolean)
    mAlertFlood = v
    WriteINI AppSettings, "Alerts", "Flood", YesNo(v)
End Property
        
Public Property Get AlertNoFlood() As Boolean
    AlertNoFlood = mAlertNoFlood
End Property

Public Property Let AlertNoFlood(ByVal v As Boolean)
    mAlertNoFlood = v
    WriteINI AppSettings, "Alerts", "NoFlood", YesNo(v)
End Property

Public Property Get AlertKicked() As Boolean
    AlertKicked = mAlertKicked
End Property

Public Property Let AlertKicked(ByVal v As Boolean)
    mAlertKicked = v
    WriteINI AppSettings, "Alerts", "Kicked", YesNo(v)
End Property
        
Public Property Let Channel(Index As Integer, v As String)
    mChannel(Index) = v
    WriteINI AppSettings, "Channel", mChannelName(Index), v
End Property

Public Property Get Channel(Index As Integer) As String
    Channel = mChannel(Index)
End Property

Private Sub Class_Initialize()
    Reload
End Sub

Private Sub Class_Terminate()
    On Error Resume Next
    Export
End Sub

Public Property Get BNLS(Index As Integer) As String
    If Index > UBound(mBNLS) Then BNLS = "bnls.bnetdev.net": Exit Property
    BNLS = mBNLS(Index)
    If LenB(BNLS) = 0 Then BNLS = "bnls.bnetdev.net"
End Property

Public Property Get BNLSCount() As Long
    BNLSCount = UBound(mBNLS)
End Property

Public Sub Export()
    Dim FF As Integer, Ar As String
    FF = FreeFile
    Ar = AppData & "Data\Other\DynamicProfile.ini"
    If Right$(ProfileAge, Len(vbNewLine)) = vbNewLine Then ProfileAge = Left$(ProfileAge, Len(ProfileAge) - Len(vbNewLine))
    If Right$(ProfileSex, Len(vbNewLine)) = vbNewLine Then ProfileSex = Left$(ProfileSex, Len(ProfileSex) - Len(vbNewLine))
    If Right$(ProfileLocation, Len(vbNewLine)) = vbNewLine Then ProfileLocation = Left$(ProfileLocation, Len(ProfileLocation) - Len(vbNewLine))
    If Right$(ProfileDescription, Len(vbNewLine)) = vbNewLine Then ProfileDescription = Left$(ProfileDescription, Len(ProfileDescription) - Len(vbNewLine))
    Open Ar For Append As #FF
    Close #FF
    Open Ar For Output As #FF
        Print #FF, "[Age]"
        Print #FF, ProfileAge
        Print #FF, "[Sex]"
        Print #FF, ProfileSex
        Print #FF, "[Location]"
        Print #FF, ProfileLocation
        Print #FF, "[Description]"
        Print #FF, ProfileDescription
    Close #FF
End Sub

Public Property Get TicTacToe() As Boolean
    TicTacToe = mTicTacToe
End Property

Public Property Let TicTacToe(v As Boolean)
    mTicTacToe = v
    WriteINI AppSettings, SE, "TicTacToe", YesNo(v)
End Property

Public Property Get Icons() As Integer
    Icons = mIcons
End Property

Public Property Let Icons(v As Integer)
    mIcons = v
    Dim I As Integer, C As Control
    For I = 0 To 2
        frmBot.mnuDIcons(I).Checked = False
    Next I
    frmBot.mnuDIcons(v).Checked = True
    WriteINI AppSettings, SE, "Icons", CStr(v & "")
    Select Case v
    Case 0
        For Each C In frmBot.Controls
            If TypeName(C) = "ListView" And C.Name <> "lvChars" Then
                If C.ListItems.Count = 0 Then
                    Set C.SmallIcons = frmBot.imlAvatar
                Else
                    C.ListItems(1).Selected = True
                    C.SelectedItem.EnsureVisible
                End If
                ApplyIcons C.hwnd
            End If
        Next
    Case 1
        For Each C In frmBot.Controls
            If TypeName(C) = "ListView" And C.Name <> "lvChars" Then
                If C.ListItems.Count = 0 Then
                    Set C.SmallIcons = frmBot.imlClassic
                Else
                    C.ListItems(1).Selected = True
                    C.SelectedItem.EnsureVisible
                End If
                ApplyIcons C.hwnd
            End If
        Next
    Case 2
        For Each C In frmBot.Controls
            If TypeName(C) = "ListView" And C.Name <> "lvChars" Then
                If C.ListItems.Count = 0 Then
                    Set C.SmallIcons = frmBot.imlModern
                Else
                    C.ListItems(1).Selected = True
                    C.SelectedItem.EnsureVisible
                End If
                ApplyIcons C.hwnd
            End If
        Next
    End Select
End Property

Public Property Get Smileys() As Boolean
    Smileys = mSmileys
End Property

Public Property Let Smileys(v As Boolean)
    mSmileys = v
    frmBot.mnuParseEmoticons.Checked = v
    WriteINI AppSettings, SE, "Smileys", YesNo(v)
End Property

Public Property Get SmileySet() As String
    SmileySet = mSmileySet
End Property

Public Property Let SmileySet(v As String)
    mSmileySet = v
    LoadEmoticons v
    WriteINI AppSettings, SE, "SmileySet", v
End Property

Public Property Get Verbose() As Boolean
    Verbose = mVerbose
End Property

Public Property Let Verbose(v As Boolean)
    mVerbose = v
    WriteINI AppSettings, SE, "Verbose", YesNo(v)
End Property

Public Property Get FriendFilter() As Boolean
    FriendFilter = mFriendFilter
End Property

Public Property Let FriendFilter(v As Boolean)
    mFriendFilter = v
    WriteINI AppSettings, "Filter", "Friend", YesNo(v)
End Property

Public Property Get AccountFilter() As Boolean
    AccountFilter = mAccountFilter
End Property

Public Property Let AccountFilter(v As Boolean)
    mAccountFilter = v
    WriteINI AppSettings, "Filter", "Account", YesNo(v)
End Property

Public Property Get JoinFilter() As Boolean
    JoinFilter = mJoinFilter
End Property

Public Property Let JoinFilter(v As Boolean)
    mJoinFilter = v
    WriteINI AppSettings, "Filter", "Join", YesNo(v)
End Property

Public Property Get PresentFilter() As Boolean
    PresentFilter = mPresentFilter
End Property

Public Property Let PresentFilter(v As Boolean)
    mPresentFilter = v
    WriteINI AppSettings, "Filter", "Present", YesNo(v)
End Property

Public Property Get EmoteFilter() As Boolean
    EmoteFilter = mEmoteFilter
End Property

Public Property Let EmoteFilter(v As Boolean)
    mEmoteFilter = v
    WriteINI AppSettings, "Filter", "Emote", YesNo(v)
End Property

Public Property Get BanFilter() As Boolean
    BanFilter = mBanFilter
End Property

Public Property Let BanFilter(v As Boolean)
    mBanFilter = v
    WriteINI AppSettings, "Filter", "Ban", YesNo(v)
End Property

Public Property Get KickFilter() As Boolean
    KickFilter = mKickFilter
End Property

Public Property Let KickFilter(v As Boolean)
    mKickFilter = v
    WriteINI AppSettings, "Filter", "Kick", YesNo(v)
End Property

Public Property Get AutoFilter() As Boolean
    AutoFilter = mAutoFilter
End Property

Public Property Let AutoFilter(v As Boolean)
    mAutoFilter = v
    WriteINI AppSettings, "Filter", "AutoFilter", YesNo(v)
End Property

Public Property Get FilterLevel() As Integer
    FilterLevel = mFilterLevel
End Property

Public Property Let FilterLevel(v As Integer)
    mFilterLevel = v
    WriteINI AppSettings, "Filter", "FilterLevel", v & ""
End Property

Public Property Get FilterLoad() As Boolean
    FilterLoad = mFilterLoad
End Property

Public Property Let FilterLoad(v As Boolean)
    mFilterLoad = v
    WriteINI AppSettings, "Filter", "FilterLoad", YesNo(v)
End Property

Public Property Get ClanRankColors() As Boolean
    ClanRankColors = mClanRankColors
End Property

Public Property Let ClanRankColors(v As Boolean)
    mClanRankColors = v
    WriteINI AppSettings, SE, "ClanRankColors", YesNo(v)
End Property

Public Property Get ClanRankIcons() As Boolean
    ClanRankIcons = mClanRankIcons
End Property

Public Property Let ClanRankIcons(v As Boolean)
    mClanRankIcons = v
    WriteINI AppSettings, SE, "ClanRankIcons", YesNo(v)
End Property

Public Property Get Abbreviate() As Boolean
    Abbreviate = mAbbreviate
End Property

Public Property Let Abbreviate(v As Boolean)
    mAbbreviate = v
    WriteINI AppSettings, SE, "Abbreviate", YesNo(v)
End Property

Public Property Get AutoReconnect() As Boolean
    AutoReconnect = mAutoReconnect
End Property

Public Property Let AutoReconnect(v As Boolean)
    mAutoReconnect = v
    WriteINI AppSettings, SE, "AutoReconnect", YesNo(v)
End Property

Public Property Get Logging() As Boolean
    Logging = mLogging
End Property

Public Property Let Logging(v As Boolean)
    mLogging = v
    WriteINI AppSettings, SE, "Logging", YesNo(v)
End Property

Public Property Get Proof() As Boolean
    Proof = mProof
End Property

Public Property Let Proof(v As Boolean)
    mProof = v
    WriteINI AppSettings, SE, "Proof", YesNo(v)
End Property

Public Property Get TrueName() As Boolean
    TrueName = mTrueName
End Property

Public Property Let TrueName(v As Boolean)
    mTrueName = v
    WriteINI AppSettings, SE, "TrueName", YesNo(v)
End Property

Public Property Get CommandDebug() As Boolean
    CommandDebug = mCommandDebug
End Property

Public Property Let CommandDebug(v As Boolean)
    mCommandDebug = v
    WriteINI AppSettings, SE, "CommandDebug", YesNo(v)
End Property

Public Property Get HideEditor() As Boolean
    HideEditor = mHideEditor
End Property

Public Property Let HideEditor(v As Boolean)
    mHideEditor = v
    WriteINI AppSettings, SE, "HideEditor", YesNo(v)
End Property

Public Property Get Nudge() As Boolean
    Nudge = mNudge
End Property

Public Property Let Nudge(v As Boolean)
    mNudge = v
    WriteINI AppSettings, SE, "Nudge", YesNo(v)
End Property

Public Property Get Colors() As Boolean
    Colors = mColors
End Property

Public Property Let Colors(v As Boolean)
    mColors = v
    WriteINI AppSettings, SE, "Colors", YesNo(v)
End Property

Public Property Get AutoConnectAll() As Boolean
    AutoConnectAll = mAutoConnectAll
End Property

Public Property Let AutoConnectAll(v As Boolean)
    mAutoConnectAll = v
    WriteINI AppSettings, SE, "AutoConnectAll", YesNo(v)
End Property

Public Property Get AutoLockAll() As Boolean
    AutoLockAll = mAutoLockAll
End Property

Public Property Let AutoLockAll(v As Boolean)
    mAutoLockAll = v
    WriteINI AppSettings, SE, "AutoLockAll", YesNo(v)
End Property

Public Property Get AutoHideAll() As Boolean
    AutoHideAll = mAutoHideAll
End Property

Public Property Let AutoHideAll(v As Boolean)
    mAutoHideAll = v
    WriteINI AppSettings, SE, "AutoHideAll", YesNo(v)
End Property

Public Property Get AutoLoadAll() As Boolean
    AutoLoadAll = mAutoLoadAll
End Property

Public Property Let AutoLoadAll(v As Boolean)
    mAutoLoadAll = v
    WriteINI AppSettings, SE, "AutoLoadAll", YesNo(v)
End Property

Public Property Get Speak() As Boolean
    Speak = mSpeak
End Property

Public Property Let Speak(v As Boolean)
    mSpeak = v
    WriteINI AppSettings, SE, "Speak", YesNo(v)
End Property

Public Property Get IdleDim() As Boolean
    IdleDim = mIdleDim
End Property

Public Property Let IdleDim(v As Boolean)
    mIdleDim = v
    WriteINI AppSettings, SE, "IdleDim", YesNo(v)
End Property

Public Property Get VoidView() As Boolean
    VoidView = mVoidView
End Property

Public Property Let VoidView(v As Boolean)
    mVoidView = v
    WriteINI AppSettings, SE, "VoidView", YesNo(v)
End Property

Public Property Get TrayMin() As Boolean
    TrayMin = mTrayMin
End Property

Public Property Let TrayMin(v As Boolean)
    mTrayMin = v
    WriteINI AppSettings, SE, "TrayMin", YesNo(v)
End Property

Public Property Get PlainText() As Boolean
    PlainText = mPlainText
End Property

Public Property Let PlainText(v As Boolean)
    mPlainText = v
    WriteINI AppSettings, SE, "PlainText", YesNo(v)
End Property

Public Property Get Password() As String
    Password = mPassword
End Property

Public Property Let Password(v As String)
    mPassword = v
    WriteINI AppSettings, SE, "MasterPassword", Encrypt(v)
End Property

Public Property Get Hyperlinks() As Boolean
    Hyperlinks = mHyperlinks
End Property

Public Property Let Hyperlinks(v As Boolean)
    mHyperlinks = v
    WriteINI AppSettings, SE, "Hyperlinks", YesNo(v)
    If SelectedBot = -1 Then Exit Property
    Dim B As BNCS
    If v Then
        EnableURLDetect frmBot.rtbChat(SelectedBot).hwnd, frmBot.hwnd
        For Each B In frmBot.Bot
            URLViewing True, frmBot.rtbChat(B.BotIndex).hwnd
        Next
    Else
        DisableURLDetect
        For Each B In frmBot.Bot
            URLViewing False, frmBot.rtbChat(B.BotIndex).hwnd
        Next
    End If
End Property


Public Sub Reload()
    Const SE As String = "Settings", FI As String = "Filter", AL As String = "Alerts"
    ReDim mBNLS(0)
    Dim Ap As String
    Ap = AppSettings
    CreateFile Ap
    TicTacToe = IsYes(ReadINI(Ap, SE, "TicTacToe"))
    SmileySet = ReadINI(Ap, SE, "SmileySet")
    Verbose = IsYes(ReadINI(Ap, SE, "Verbose"))
    AutoReconnect = IsYes(ReadINI(Ap, SE, "AutoReconnect"))
    AutoConnectAll = IsYes(ReadINI(Ap, SE, "AutoConnectAll"))
    AutoHideAll = IsYes(ReadINI(Ap, SE, "AutoHideAll"))
    AutoLoadAll = IsYes(ReadINI(Ap, SE, "AutoLoadAll"))
    AutoLockAll = IsYes(ReadINI(Ap, SE, "AutoLockAll"))
    Logging = IsYes(ReadINI(Ap, SE, "Logging"))
    Proof = IsYes(ReadINI(Ap, SE, "Proof"))
    ClanRankIcons = IsYes(ReadINI(Ap, SE, "ClanRankIcons"))
    CommandDebug = IsYes(ReadINI(Ap, SE, "CommandDebug"))
    Nudge = IsYes(ReadINI(Ap, SE, "Nudge"))
    Colors = IsYes(ReadINI(Ap, SE, "Colors"))
    Smileys = IsYes(ReadINI(Ap, SE, "Smileys"))
    Speak = IsYes(ReadINI(Ap, SE, "Speak"))
    Hyperlinks = IsYes(ReadINI(Ap, SE, "Hyperlinks"))
    IdleDim = IsYes(ReadINI(Ap, SE, "IdleDim"))
    VoidView = IsYes(ReadINI(Ap, SE, "VoidView"))
    TrayMin = IsYes(ReadINI(Ap, SE, "TrayMin"))
    PlainText = IsYes(ReadINI(Ap, SE, "PlainText"))
    Icons = Val(ReadINI(Ap, SE, "Icons"))
    Password = Decrypt(ReadINI(Ap, SE, "MasterPassword"))
    HideEditor = IsYes(ReadINI(Ap, SE, "HideEditor"))
    TrueName = IsYes(ReadINI(Ap, SE, "TrueName"))
    Abbreviate = IsYes(ReadINI(Ap, SE, "Abbreviate"))
    KickFilter = IsYes(ReadINI(Ap, FI, "Kick"))
    BanFilter = IsYes(ReadINI(Ap, FI, "Ban"))
    EmoteFilter = IsYes(ReadINI(Ap, FI, "Emote"))
    FriendFilter = IsYes(ReadINI(Ap, FI, "Friend"))
    AccountFilter = IsYes(ReadINI(Ap, FI, "Account"))
    JoinFilter = IsYes(ReadINI(Ap, FI, "Join"))
    PresentFilter = IsYes(ReadINI(Ap, FI, "Present"))
    AutoFilter = IsYes(ReadINI(Ap, FI, "AutoFilter"))
    FilterLevel = Val(ReadINI(Ap, FI, "FilterLevel"))
    FilterLoad = IsYes(ReadINI(Ap, FI, "FilterLoad"))
    AlertFlood = IsYes(ReadINI(Ap, AL, "Flood"))
    AlertNoFlood = IsYes(ReadINI(Ap, AL, "NoFlood"))
    AlertKicked = IsYes(ReadINI(Ap, AL, "Kicked"))
    
    mChannelName(0) = "Boring"
    mChannelName(1) = "Idle"
    mChannelName(2) = "RecActive"
    mChannelName(3) = "Active"
    mChannelName(4) = "Heavy"
    mChannelName(5) = "Moderate"
    mChannelName(6) = "Weak"
    Dim I As Integer
    For I = 0 To 6
        mChannel(I) = ReadINI(Ap, "Channel", mChannelName(I))
        If LenB(mChannel(I)) = 0 Then mChannel(I) = frmOptions.txtCh(I).ToolTipText
    Next I
    
    Dim FF As Integer, L As String, Ar As String, P As Integer
    FF = FreeFile
    Ar = AppData & "Data\Other\BnlsServers.ini"
    Open Ar For Append As #FF
    Close #FF
    Open Ar For Input As #FF
    Do Until EOF(FF)
        Line Input #FF, L
        If LenB(L) > 0 Then
            If LenB(mBNLS(0)) > 0 Then ReDim Preserve mBNLS(UBound(mBNLS) + 1)
            mBNLS(UBound(mBNLS)) = L
        End If
    Loop
    Close #FF
    
    FF = FreeFile
    Ar = AppData & "Data\Other\DynamicProfile.ini"
    ProfileAge = vbNullString
    ProfileSex = vbNullString
    ProfileLocation = vbNullString
    ProfileDescription = vbNullString
    Open Ar For Append As #FF
    Close #FF
    Open Ar For Input As #FF
    Do Until EOF(FF)
        Line Input #FF, L
        Select Case L
        Case "[Age]": P = 1
        Case "[Sex]": P = 2
        Case "[Location]": P = 3
        Case "[Description]": P = 4
        Case Else
            Select Case P
            Case 1: ProfileAge = ProfileAge & L & vbNewLine
            Case 2: ProfileSex = ProfileSex & L & vbNewLine
            Case 3: ProfileLocation = ProfileLocation & L & vbNewLine
            Case 4: ProfileDescription = ProfileDescription & L & vbNewLine
            End Select
        End Select
    Loop
    Close #FF
    If Right$(ProfileAge, Len(vbNewLine)) = vbNewLine Then ProfileAge = Left$(ProfileAge, Len(ProfileAge) - Len(vbNewLine))
    If Right$(ProfileSex, Len(vbNewLine)) = vbNewLine Then ProfileSex = Left$(ProfileSex, Len(ProfileSex) - Len(vbNewLine))
    If Right$(ProfileLocation, Len(vbNewLine)) = vbNewLine Then ProfileLocation = Left$(ProfileLocation, Len(ProfileLocation) - Len(vbNewLine))
    If Right$(ProfileDescription, Len(vbNewLine)) = vbNewLine Then ProfileDescription = Left$(ProfileDescription, Len(ProfileDescription) - Len(vbNewLine))
End Sub
